/*
  Write a string of text as a line of Braille.

  This is a very SIMPLE Braille parsing routine, intended for SIMPLE 3D printed badges, signs or instructions. Sentence and single word capitalisation are implemented, any uppercase beyond that is ignored. Simple non-negative numbers are parsed correctly, as well as phone numbers as long as they do NOT contain spaces (spaces cause successive numbers to be ).

  The GHOUL tries to adhere to and parse Unified English Braille.

  The Braille patterns are defined in 'TheGHOUL/Lib/Definitions/Braille.scad'.
*/
/* TODO: Capitalisation indicator. */
module BrailleText(String="Hello World"){

    /* Grab the numeric indicator from the patterns list. */
    NC=BraillePatterns[search(["NumericIndicator"],BraillePatterns)[0]][2];
    DS=BraillePatterns[search(["DotSix"],BraillePatterns)[0]][2];

    Patterns=FlattenArray([
        for(Cdex=[0:Len(String)])
            let(
                CChar=String[Cdex], // Current character
                PChar=String[Cdex-1], // Previous character
                Pattern=BraillePatterns[search(CChar,BraillePatterns)[0]][2]
            )
            search(CChar,Digits)[0]==undef
            /* If the current character is not a digit. */
            ?   search(CChar,UpperCase)[0]==undef
                /* And it's not an uppercase character, parse it. */
                ?   Pattern
                :   Cdex==0||PChar==" "
                    /* First character or uppercase following a space. */
                    ?   concat(DS,Pattern)
                    /* All else, case is ignored. */
                    :   Pattern
            :   search(PChar,BrailleNumerics)[0]==undef
                /* If the previous character is not a Braille numeric character--(digits, decimal, and comma), and thus the current character is the first (in a series of) digit(s)--prefix the numeric indicator. */
                ?   concat(NC,Pattern)
                /* Else just parse the character. */
                :   Pattern
    ]);

    for(Jdex=[0:Len(Patterns)])
        translate([BrailleCellSpacing*Jdex,0,0])
        BrailleCell(Patterns[Jdex]);

}

/* generate a single cell (character). */
module BrailleCell(DotPattern){

    BDS=BrailleDotSpacing;
    DotCoords=  [[[0,2*BDS,0],[0,BDS,0],[0,0,0],[0,-BDS,0]],
                [[BDS,2*BDS,0],[BDS,BDS,0],[BDS,0,0],[BDS,-BDS,0]]];

    for(Idex=[0:1],Jdex=[0:3])
        if(DotPattern[Idex][Jdex]==1)
            translate(DotCoords[Idex][Jdex])
            BrailleDot();
}

/* Generate a single dot. */
module BrailleDot(){
    sphere(r=BrailleDotRadius);
}

/* A dot minus its 'bottom'. */
module BrailleDotC(){
    difference(){
        sphere(r=BrailleDotRadius);
        translate([0,0,-1])
        cube([2,2,2,],center=true);
    }
}

