// Text that stays in the same location on the screen. Requires regen.
module ScreenText(Text="Text.",Location=[0,-5,0],Rotation=[15,25,0],Size=1,Thickness=1,Color=DSG,_SizeCompensation=40,_ScreenFactor=40,_Correction=[0,0,0]){
    color(Color)
    // Compensate for viewport translation and rotation ($vpt and $vpr).
    translate($vpt)
    rotate($vpr)
    // Place on screen, compensated for distance ($vpd).
    translate(Location*$vpd/_ScreenFactor)
    // Make the font look good.
    rotate(Rotation)
    translate(_Correction)
    // Text size is compensated for $vpd.
    SimpleText(Text,Size*$vpd/_SizeCompensation,Thickness*$vpd/_SizeCompensation,Center=true,Font="Noto Mono",Spacing=1);
}

/*
  text(t, size, font,
     halign, valign, spacing,
     direction, language, script).
*/


// Text that stays in the same location on the screen. Requires regen.
module VPRText(Text="Text.",Size=1,Font="Noto Mono",Halign="left",Valign="baseline",Spacing=1,Thickness=1,Location=[0,0,0],Rotation=[15,25,0]){
    // I like to move-it, move-it... No? Oh, never mind.
    translate(Location)
    // Compensate for viewport rotation $vpr.
    rotate($vpr)
    // Make the font look good.
    rotate(Rotation)
    linear_extrude(Thickness)
    // Text size is compensated for $vpd.
    text(text=Text,size=Size,font=Font,halign=Halign,valign=Valign,spacing=Spacing);
}
