// TODO: Kerning.
module SimpleBarrelText(String,Size,Radius,Helix=0,Thickness=0.1,Center=false,Font="Noto Mono",Spacing=1,Raise=0,Vert=false)
{

    // Generate character widths array.
    Track=MapString(String,MonoTrack);
    // Generate character kerning array. TODO: Needs implementation.
    Kern=MapString(String,MonoKern);
    // 0-Effect Track+Kern summation, to be implemented with Kern
    _Track=[ for(I=[0:len(Track)-1]) Track[I] ];

    // This needs correction when Kern is truly implemented.
    TotalWidth=(ArraySum(_Track))*Size*Spacing;
    // Check for room.
    TotalAngle=TotalWidth/Tau/Radius*360;
    SpaceAngle=Size*Spacing/Tau/Radius*360;
    ErrorOnTrue(str("String does not fit on Radius, total required angle is ",TotalAngle+SpaceAngle*2,"."),TotalAngle>360-SpaceAngle*2);

    // Correct center vertically for Helix.
    translate([0,0,Center?sin(Helix)*TotalWidth/2:0])
    // Correct Azimuth to positive X-axis and rotate for center.
    rotate([0,0,90+(Center?-TotalAngle/2:0)])
    for(Character=[0:len(String)-1])
    // Lower down to Helix.
    translate([0,0,-sin(Helix)*((ArraySum(_Track,0,Character)-Track[0]+Kern[0])*Size*Spacing)])
    // Rotate azimuthal angle.
    rotate([0,0,cos(Helix)*((ArraySum(_Track,0,Character)-Track[0]+Kern[0])*Size*Spacing/Tau/Radius*360)])
    // Place on radius.
    translate([0,-Radius-Raise,0])
    // Correct for Helix angle.
    rotate([0,Vert?-90:0,0])
    rotate([90,Helix,0])
    // Center on Y-axis.
    translate([-Kern[Character]*Size*Spacing,(Center?-Size/2:0),0])
    linear_extrude(Thickness)
    text(String[Character],size=Size,font=Font);
}

