module SimpleCircleText(String,Size,Radius,Thickness=0.1,Center=false,CW=false,Font="Noto Mono",Spacing=1)
{

    // Generate character widths array.
    Track=MapString(String,MonoTrack);
    // Generate character kerning array. TODO: Needs implementation.
    Kern=MapString(String,MonoKern);
    // Generate character kerning array. TODO: Needs implementation.
    _Track=[ for(I=[0:len(Track)-1]) Track[I] ];
    // Correct Radius for text height.
    _Radius=Radius-Size/2;

    // TODO kerning implementation
    TotalWidth=(ArraySum(_Track))*Size*Spacing;
    TotalAngle=TotalWidth/Tau/_Radius*360;
    // Check for room.
    SpaceAngle=Size*Spacing/Tau/_Radius*360;
    ErrorOnTrue(str("String does not fit on Radius, total required angle is ",TotalAngle+SpaceAngle*2,"."),TotalAngle>360-SpaceAngle*2);

    /*
      Characters are generated, translated to [character center, +/- radius,0] where + or - is determined by CW or CCW, rotated into position in the string, then string is rotated depending on *Center*= true or false.
    */
    // Correct Azimuth to positive X-axis and center text if required.
    rotate([0,0,(CW?-90:90)+(Center?-TotalAngle/2:0)*(CW?-1:1)])
    for(Character=[0:len(String)-1])
        // Row characters up on radius. === TODO kerning implementation
        rotate([0,0,(ArraySum(_Track,0,Character)-Track[0]+Kern[0])*Size*Spacing/Tau/_Radius*360*(CW?-1:1)])
        /*
          Put character BASELINE on radius and centered on Y-axis. The baseline is the line on which the characters 'sit' or 'stand'. This yields quite different results for CW and CCW; the user can compensate for this with *Radius* and *Spacing*.
        */
        translate([-Kern[Character]*Size*Spacing,CW?Radius:-Radius,0])
        // Generate character
        linear_extrude(Thickness)
        text(String[Character],size=Size,font=Font);
}

