// TODO: Kerning - rename Spacing to Kerning
module SimpleText(String,Size=1,Thickness=0.1,Center=false,Font="Noto Mono",Spacing=1)
{

    // Generate character widths array.
    Track=MapString(String,MonoTrack);
    // Generate character kerning array. TODO: Needs implementation.
    Kern=MapString(String,MonoKern);
    // 0-Effect Track+Kern summation, to be implemented with Kern
    _Track=[ for(I=[0:len(Track)-1]) Track[I] ];

    // This needs correction when Kern is truly implemented.
    TWidth=ArraySum(_Track)*Size*Spacing;

    // Center string.
    translate([Center?-TWidth/2:0,0,0])
    for(Character=[0:len(String)-1])
    // Row up.
    translate([(ArraySum(_Track,0,Character)-Track[0]+Kern[0])*Size*Spacing,0,0])
    // Center on Y-axis.
    translate([-Kern[Character],Center?-Size/2:0,0])
    linear_extrude(Thickness)
    text(String[Character],size=Size,font=Font);
}
