/*
    Interval(1.2,3,12.9) => [1.2, 3, 6, 9, 12, 12.9]

    Generates a range from start to end, both inclusive, with all multiples of *Factor* that fall in between.

    If the distance to the closest iteration of *Factor* to either *Start* or *End* is less than *Resolution*, that iteration is skipped, e.g.:

        Interval(1.8,2,6.6)     => [1.8, 2, 4, 6, 6.6]
    but
        Interval(1.8,2,6.6,0.5) => [1.8, 4, 6, 6.6]
    .
*/
function Interval(Start,Factor,End,Resolution=0)=
    concat(
        [Start],
        [
            for(I=[MCeil(Start+Resolution,Factor):Factor:MFloor(End-Resolution,Factor)])
                I
        ],
        [End]
    )
;
