/*
    RemoveElement([4, 3, 2, 1], 1) => [4, 2, 1]
*/
function RemoveElement(Tuple, Index)=
    let(
        _Index=Dex(Index,Len(Tuple)),
        Foo=Alert(["Index out of range at ",Index,", mapped onto ",_Index,"."],0,abs(Index)>Len(Tuple))
    )
    /* First check for single element tuples. */
    len(Tuple)==1
    /* Is the element to be removed the only (first) element?. */
    ?   _Index==0
        /* Return empty tuple. */
        ?   []
        :   undef
    :
    [ for (Jdex = [0 : len(Tuple)-2])
        Tuple[
            Jdex >= _Index
            ?   Jdex+1
            :   Jdex
        ]
    ]
;

function RemoveElements(Tuple,Indices)=
    len(Indices)>0
    ?   RemoveElements(RemoveElement(Tuple,Indices[0]),RemoveElement(Indices,0))
    :   Tuple
;
