/*
  Cross product of two vectors.

  |   CrossProduct([1, 2, 3, 4], [5, 6, 7, 8]) => [-4, -4, 12, -4]

  The native function 'cross()' only accepts vectors of length 3.
*/
function CrossProduct(Vector1,Vector2) =
    let(Length=len(Vector1))
    len(Vector1) != len(Vector2)
    ?   undef
    :   concat(
            [ for (Index = [1 : Length-2])
                Vector1[Index] * Vector2[Index+1] - Vector1[Index+1] * Vector2[Index]
            ],
            Vector1[Length-1] * Vector2[0] - Vector1[0] * Vector2[Length-1],
            Vector1[0] * Vector2[1] - Vector1[1] * Vector2[0]
        )
;

function IsCollinear(V1,V2)=
    ArraySum(CrossProduct(V1,V2))==0
    ?   true
    :   false
;

function AreCollinear(V1,V2,V3)=
    ArraySum(CrossProduct(V1-V2,V3-V2))==0
    ?   true
    :   false
;
