/*
  Generate a vector of given length and direction.
  The direction can be specified as a vector or an angle.
  The result is always a 3D vector of the given length and direction, however, when the input is an _angle_, the resulting vector will always have Z=0.
*/
function LengthVector(VectorOrAngle=0,Length=1)=
    is_num(VectorOrAngle)
    /* We have been given an angle. */
    ?   [cos(VectorOrAngle),sin(VectorOrAngle),0]*Length
    /* We have been given a vector. */
    :   Length/Modulus(VectorOrAngle)*VectorOrAngle
;
