/*
 * TODO: offset for solids like the boat
 * create outer hull polygons, then add offsets starting at the last polygon
 * so order of polygons is up, in and down like a tubular-ish...
*/
/*
  For more info, see the documentation in Bisect.scad, also in this directory.
  Add a vector of length 'Dist' to V2, in the direction bisecting the _acute angle_ formed by V1-V2-V3.
*/
function OffsetAcute(V1,V2,V3,Dist)=
    V2+BisectAcute(V1,V2,V3)*Dist
;
/* Because OffsetAcute() is the default method, here's the default alias. */
function Offset(V1,V2,V3,Dist)=
    V2+BisectAcute(V1,V2,V3)*Dist
;

/* As Offset() but bisecting the _obtuse angle_. No sense in calling BisectObtuse(); we can call BisectAcute() and add a '-' ourselves, thank you.*/
function OffsetObtuse(V1,V2,V3,Dist)=
    V2+BisectAcute(V1,V2,V3)*-Dist
;

/* As Offset() but always to the left. */
function OffsetLeft(V1,V2,V3,Dist)=
    V2+BisectLeft(V1,V2,V3)*Dist
;

/* As Offset() but always to the right. No sense in calling BisectRight(); we can call BisectLeft() and add a '-' ourselves, thank you.*/
function OffsetRight(V1,V2,V3,Dist)=
    V2+BisectLeft(V1,V2,V3)*-Dist
;

