/*
  Convert [Radius, Inclination, Azimuth] or [Radius, Azimuth] to vector coordinates.
  Radius: Length of the resulting vector.
  Azimuth: Angle CCW from the positive X-axis in degrees (0-360).
  Inclination: Angle from the positive Z-Axis in degrees (0-180 inc.).
*/
/* TODO: Rename Force3D to 3D */
function PolarToVector(Polar,Force3D=false)=
    len(Polar)==2
    ?   [
            Polar.x*cos(Polar.y),
            Polar.x*sin(Polar.y),
            if(Force3D)0
        ]
    :   [
            Polar.x*cos(Polar.z)*sin(Polar.y),
            Polar.x*sin(Polar.z)*sin(Polar.y),
            Polar.x*cos(Polar.y)
        ]
;
