/*
  Convert a vector to Polar Inclination and Azimuth angles, expressed as a 'rotation tuple'. The resulting tuple can be used for rotate() to align an object with the vector, because unlike a true polar, the radius is 0, and thus the triple becomes a rotate([0,y,z]) with y the inclination and z the azimuth angle.
  The object must be aligned with the positive Z-axis before the rotation. If 'Vector' is 2D, a 0 Z-coordinate will be appended.
*/
function VectorToIncAz(Vector) =
    let(
        Polar=VectorToPolar(Vector)
    )
    [
       0,
       Polar.y,
       Polar.z
    ]
;
