/*
  Convert a vector to Polar coordinates [Radius,Inclination,Azimuth].
  Accepts 2D as well as 3D vectors, but always returns full 3D polar coordinates.
*/
function VectorToPolar(Vector) =
    let(
        _Vector=PadTuple(Vector),
        Mdls=Modulus(_Vector)
    )
    /* 0-length yields infinity, which is troublesome... */
    Mdls==0
    ?   [0,0,0]
    /* [Radius, Inclination, Azimuth] */
    :   [
           Mdls,
           acos(_Vector.z/Mdls),
           atan2(_Vector.y,_Vector.x)
        ]
;
