/*
  Useful to visualise and adjust curves, think Bézier curves or shapes used
  for rotate_extrude() and such.
  Curve     :   An array of vertices.
  Radius    :   Radius of the generated curve.
  Frac      :   fraction of the curve to display, useful for animations &c.
  Connect   :   Connect the vertices if true.
  Closed    :   Close the curve if true.
*/
/* TODO: Large angle fold-back issues in 'CoverMesh' method. */
/*
  ShowCurve() needs $fc for curve element resolution.
  Do NOT feed it $fn values in the call, it is futility...
*/
module ShowCurve(Curve,Radius,Frac=1,Connect=true,Closed=false){

    // Use $fc--if set--to construct the curve's elements, or the 'default' number of segments otherwise.
    $fn=$fc==0
    ?   Segments(Radius,$fn=0) // $fn=0 here 'disables' $fn in Segments().
    :   $fc;
    /* Minimum curve length is 2 vertices. Some *Frac* induced juggling... */
    End=Frac<1?max((Len(Curve)+(Closed?1:0))*Frac,1):Len(Curve);

    // Because of the wonderfully wicked ways of the OpenSCAD gods, who decided that a sphere(), made under an $fn value that's (n*4) or (n*4)-1, should have no vertices in its equator plane--making the diameter of, arguably, its most important great circle undersize--we have to correct that rubbish here, so the terminating spheres are always the same size as the curve members. SMFH. Again...
    // Generally, we _should_ be looking at a 4-fold here, *but* the user could have set $fc to some non-preferred value, so:
    //ORad=(2*ceil($fn/2))%4==0?OutRadius(Radius):Radius;
/* TODO: Do we want to go back to OutRadius()? */
    ORad=Radius;

    CRV=PadArray(Curve);

    Position(CRV[1]-CRV[0],CRV[0])
    sphere(ORad);
    if(End>1)
        for(Idex=[1:End-1])
            Position(CRV[Idex+1]-CRV[Idex-1],CRV[Idex])
            sphere(ORad);
    Position(CRV[End]-CRV[End-1],CRV[End])
    sphere(ORad);

    if(Connect){
        for(Idex=[0:End-1])
            CylinderBetween(CRV[Idex],CRV[Idex+1],Radius);
        if(Closed&&Frac==1)
            CylinderBetween(CRV[End],CRV[0],Radius);
    }

/*
            CoverMesh(
            concat(
                [AffinePosition(Section,CRV[1]-CRV[0],CRV[0],90)],
                [   if(End>1)
                        for(Index=[1:End-1])
                            AffinePosition(Section,CRV[Index+1]-CRV[Index-1],CRV[Index],90)
                ],
                [AffinePosition(Section,CRV[End]-CRV[End-1],CRV[End],90)]
            )
        // Another sneaky *Frac* juggle.
        ,Endcaps=true,Donut=_Closed,Convexity=10);
*/
}

