/*TODO add translation after rotation capability
  Usage:    Highlight a slice (i.e. cross-section) of the children objects.
  Input:    Translation T [units] and rotation R [degrees] of the Slice, only
            non-zero values need to be specified.
            Thickness = Thickness of the Slice.
            Children = Switch to show children (default = true).
 */
module ShowSlice(TX=0,TY=0,TZ=0,RX=0,RY=0,RZ=0,
             Thickness=0.01,Children=true,
             SliceColor="green",SliceAlpha=1.0,
             ChildColor="yellow",ChildAlpha=0.3) {

    Rotation=[RX,RY,RZ];
    Translation=[TX,TY,TZ];
    Cube=[1000,1000,Thickness];

    intersection(){
        color(SliceColor,SliceAlpha)
        translate(Translation)
        rotate(Rotation)
        cube(Cube,center=true);
        children();
    }
    if(Children)color(ChildColor,ChildAlpha)children();
}

