/*

  <SandBox.scad>

  Hank J. van Leuvensteijn Jr. 2019
  hankjr@hankjr.ca

  This work is licensed under the Unlicense. Do with it as you please, it's not guaranteed to be good for or at anything, actually, it comes with a strict 'Un-Guarantee', declaring it to be fit for nothing at all. Use it at your peril. See License.txt in this directory. Go to <http://unlicense.org/> for more information.

  This is the SandBox.
  This file contains modules that serve no other purpose than to provide a limited scope in which to play with (new) routines etc. Un-comment a call to play within that specific SandBox#() module. To create a new SandBox, add the consecutively numbered call and module ('0' in this example/template) e.g:

//SandBox0(); // Description -----------------------------------
module SandBox0()
{  Echo(["SandBox0 is active."]);

    // Put your test-code here.

}

  To activate a particular SandBox, simply un-comment it's call (that's the first comment delimiter in the code block above).

*/

// Can't do a thing without...
include<TheGHOUL/Config.scad>

/*
  Viewpoint declaration, must be in top-namespace.
*/
//$vpt=[0,0,0];$vpr=[50,0,40];$vpd=42;

/*
  $AnimSegs (for any animation sequences) is set in Config.scad to 10 segments. It's here in case we're testing a sequence of a length that isn't 10 seconds... ;-)
*/
//$AnimSegs=10;

// Comment the next line to kill ALL SandBoxes =================================
TheSandBox();
module TheSandBox()
{ // ######################################################### The SandBox Start

    //SandBox1(); // Description --------------------------------------
    module SandBox1()
    {   Echo(["SandBox1 is active."]);

        // Put your test-code here.

    }

    // Put as many sandboxes here as you want ----------------------------------

} // ########################################################### The SandBox End


// The Punisher ================================================================
/*
  Timing a routine (under Linux): Use the following command (in a terminal) to time the runtime execution of any .scad file:

  time openscad -o echo.echo ./SandBox.scad

  Use that for example for checking the efficiency of functions, in combination with this 'Punisher()' module:
*/
//Punisher();
module Punisher()
{ Echo(["The Punisher is active in the SandBox."]);

    /*
         CCCC   AAA   U   U  TTTTT  I   OOO   N   N   !!
        C      A   A  U   U    T    I  O   O  NN  N   !!
        C      AAAAA  U   U    T    I  O   O  N N N   !!
        C      A   A  U   U    T    I  O   O  N  NN
         CCCC  A   A   UUU     T    I   OOO   N   N   !!

        *Repetitions* can VERY quickly get you into trouble. Start LOW and step up CAREFULLY or you'll be sending your 'puter into a pit of despair.
    */

    Repetitions=10;

    Foo=[   for(Idex=[0:Repetitions])
            [   for(Jdex=[0:Repetitions])
                    // Call function to be tested.
                Factorial(Repetitions) // This is just a 'placeholder'.
            ]
        ];

}
